/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.util;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class Helper
extends de.teamlapen.vampirism.util.Helper {
    public static boolean isWerewolf(Entity entity) {
        return WReference.WEREWOLF_FACTION.equals((Object)VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isWerewolf(Player entity) {
        return VampirismAPI.getFactionPlayerHandler((Player)entity).map(h -> WReference.WEREWOLF_FACTION.equals((Object)h.getCurrentFaction())).orElse(false);
    }

    public static boolean hasFaction(Entity entity) {
        if (VampirismAPI.factionRegistry().getFaction(entity) != null) {
            return true;
        }
        return Helper.isWerewolf(entity);
    }

    public static BlockPos multiplyBlockPos(BlockPos pos, double amount) {
        return new BlockPos((int)((double)pos.m_123341_() * amount), (int)((double)pos.m_123342_() * amount), (int)((double)pos.m_123343_() * amount));
    }

    public static boolean canBecomeWerewolf(Player player) {
        return FactionPlayerHandler.getOpt((Player)player).map(v -> v.canJoin(WReference.WEREWOLF_FACTION)).orElse(false);
    }

    public static boolean isNight(Level world) {
        long time = world.m_46468_() % 24000L;
        return !world.m_6042_().m_63967_() && time > 12786L && time < 23216L;
    }

    public static boolean isFullMoon(Level world) {
        long time = world.m_46468_() % 192000L;
        return !world.m_6042_().m_63967_() && time > 12786L && time < 23216L;
    }

    public static Map<Item, Integer> getMissingItems(Container inventory, Item[] items, int[] amount) {
        int i;
        HashMap<Item, Integer> missing = new HashMap<Item, Integer>();
        for (i = 0; i < items.length; ++i) {
            missing.put(items[i], amount[i]);
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            missing.computeIfPresent(stack.m_41720_(), (item, amount1) -> amount1 - stack.m_41613_());
        }
        missing.entrySet().removeIf(s -> (Integer)s.getValue() <= 0);
        return missing;
    }

    public static boolean canWerewolfEatItem(LivingEntity entity, ItemStack stack) {
        return !stack.m_41614_() || stack.m_204117_(ModTags.Items.COOKEDMEATS) || WerewolvesConfig.SERVER.isCustomMeatItems(stack.m_41720_()) || stack.m_204117_(ModTags.Items.RAWMEATS) || WerewolvesConfig.SERVER.isCustomRawMeatItems(stack.m_41720_()) || stack.m_41720_().getFoodProperties(stack, entity).m_38746_();
    }

    public static boolean canWerewolfPlayerEatItem(Player player, ItemStack stack) {
        return Helper.canWerewolfEatItem((LivingEntity)player, stack) || WerewolfPlayer.getOpt(player).map(w -> w.getSkillHandler().isSkillEnabled((ISkill)ModSkills.NOT_MEAT.get())).orElse(false) != false;
    }

    public static boolean isRawMeat(ItemStack stack) {
        return stack.m_41614_() && stack.m_41720_().m_41473_().m_38746_() && stack.m_204117_(ModTags.Items.RAWMEATS);
    }

    public static IWerewolf asIWerewolf(LivingEntity entity) {
        if (entity instanceof IWerewolf) {
            return (IWerewolf)entity;
        }
        if (entity instanceof Player) {
            return WerewolfPlayer.get((Player)entity);
        }
        return null;
    }

    public static boolean matchesItem(Ingredient ingredient, ItemStack searchStack) {
        return Arrays.stream(ingredient.m_43908_()).anyMatch(stack -> ItemStack.m_41656_((ItemStack)stack, (ItemStack)searchStack) && stack.areShareTagsEqual(searchStack));
    }

    public static MutableComponent joinComponents(String delimiter, MutableComponent ... components) {
        MutableComponent comp = components[0];
        for (int i = 1; i < components.length; ++i) {
            comp.m_130946_(delimiter).m_7220_((Component)components[i]);
        }
        return comp;
    }
}

