/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world;

import de.teamlapen.werewolves.world.ModDamageSources;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WerewolvesWorld {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Capability<WerewolvesWorld> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<WerewolvesWorld>(){});
    private final Level level;
    private final ModDamageSources damageSources;

    @Deprecated
    @NotNull
    public static WerewolvesWorld get(@NotNull Level level) {
        return (WerewolvesWorld)level.getCapability(CAP).orElseThrow(() -> new IllegalStateException("Cannot get WerewolvesWorld from World " + level));
    }

    @NotNull
    public static LazyOptional<WerewolvesWorld> getOpt(@NotNull Level level) {
        LazyOptional opt = level.getCapability(CAP);
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get world capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    @NotNull
    public static ICapabilityProvider createNewCapability(final @NotNull Level level) {
        return new ICapabilitySerializable<CompoundTag>(){
            final WerewolvesWorld inst;
            final LazyOptional<WerewolvesWorld> opt;
            {
                this.inst = new WerewolvesWorld(level);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadNBTData(nbt);
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            @NotNull
            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveNBTData(tag);
                return tag;
            }
        };
    }

    public WerewolvesWorld(Level level) {
        this.level = level;
        this.damageSources = new ModDamageSources(level.m_9598_());
    }

    private void loadNBTData(CompoundTag nbt) {
    }

    private void saveNBTData(CompoundTag nbt) {
    }

    public ModDamageSources damageSources() {
        return this.damageSources;
    }
}

