/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.world.gen.modifier.ExtendedAddSpawnsBiomeModifier;
import de.teamlapen.werewolves.config.CommonConfig;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.world.gen.ConfigIntProvider;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class WerewolvesBiomeFeatures {
    public static final DeferredRegister<IntProviderType<?>> INT_PROVIDER = DeferredRegister.create((ResourceKey)Registries.f_256949_, (String)"werewolves");
    public static final RegistryObject<IntProviderType<ConfigIntProvider>> CONFIG_INT_PROVIDER = INT_PROVIDER.register("config_int_provider", () -> () -> ConfigIntProvider.CODEC);
    public static final ResourceKey<ConfiguredFeature<?, ?>> JACARANDA_TREE = WerewolvesBiomeFeatures.createConfiguredKey("jacaranda_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAGIC_TREE = WerewolvesBiomeFeatures.createConfiguredKey("magic_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAGIC_TREE_BIG = WerewolvesBiomeFeatures.createConfiguredKey("magic_tree_big");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WOLFSBANE = WerewolvesBiomeFeatures.createConfiguredKey("wolfsbane");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE = WerewolvesBiomeFeatures.createConfiguredKey("silver_ore");
    public static final ResourceKey<PlacedFeature> JACARANDA_TREE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("jacaranda_tree");
    public static final ResourceKey<PlacedFeature> MAGIC_TREE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("magic_tree");
    public static final ResourceKey<PlacedFeature> MAGIC_TREE_BIG_PLACED = WerewolvesBiomeFeatures.createPlacedKey("magic_tree_big");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEREWOLF_HEAVEN_TREES = WerewolvesBiomeFeatures.createConfiguredKey("werewolf_heaven_trees");
    public static final ResourceKey<PlacedFeature> WOLFSBANE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("wolfsbane");
    public static final ResourceKey<PlacedFeature> WEREWOLF_HAVEN_TREES_PLACED = WerewolvesBiomeFeatures.createPlacedKey("heaven_trees");
    public static final ResourceKey<PlacedFeature> SILVER_ORE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("silver_ore");
    public static final ResourceKey<BiomeModifier> WEREWOLF_SPAWN = WerewolvesBiomeFeatures.createModifierKey("spawn/werewolf_spawns");
    public static final ResourceKey<BiomeModifier> HUMAN_WEREWOLF_SPAWN = WerewolvesBiomeFeatures.createModifierKey("spawn/human_werewolf_spawns");
    public static final ResourceKey<BiomeModifier> SILVER_ORE_GEN = WerewolvesBiomeFeatures.createModifierKey("gen/silver_ore");
    public static final ResourceKey<BiomeModifier> WOLFSBANE_GEN = WerewolvesBiomeFeatures.createModifierKey("gen/wolfsbane");

    public static void register(IEventBus bus) {
        INT_PROVIDER.register(bus);
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createConfiguredKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("werewolves", name));
    }

    private static ResourceKey<PlacedFeature> createPlacedKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("werewolves", name));
    }

    private static ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("werewolves", name));
    }

    private static ResourceKey<StructureSet> createStructureSetKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)new ResourceLocation("werewolves", name));
    }

    public static void addWerewolvesFlowers(BiomeGenerationSettings.Builder biomeGeneratorSettings) {
        biomeGeneratorSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WOLFSBANE_PLACED);
    }

    public static void addWerewolfBiomeTrees(BiomeGenerationSettings.Builder biomeGeneratorSettings) {
        biomeGeneratorSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WEREWOLF_HAVEN_TREES_PLACED);
    }

    public static void init() {
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(CommonConfig.IntValueExt p_195344_, PlacementModifier p_195345_) {
        return WerewolvesBiomeFeatures.orePlacement((PlacementModifier)CountPlacement.m_191630_((IntProvider)ConfigIntProvider.of(p_195344_)), p_195345_);
    }

    private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
        return WerewolvesBiomeFeatures.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)p_195350_), p_195351_);
    }

    public static void createConfiguredFeatures(BootstapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        TagMatchTest stoneTest = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateTest = new TagMatchTest(BlockTags.f_144267_);
        context.m_255272_(JACARANDA_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((RotatedPillarBlock)ModBlocks.JACARANDA_LOG.get()).m_49966_()), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.JACARANDA_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_()));
        context.m_255272_(MAGIC_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((RotatedPillarBlock)ModBlocks.MAGIC_LOG.get()).m_49966_()), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((LeavesBlock)ModBlocks.MAGIC_LEAVES.get()).m_49966_()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_()));
        context.m_255272_(MAGIC_TREE_BIG, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((RotatedPillarBlock)ModBlocks.MAGIC_LOG.get()).m_49966_()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((LeavesBlock)ModBlocks.MAGIC_LEAVES.get()).m_49966_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 1, OptionalInt.of(4))).m_68244_().m_68251_()));
        context.m_255272_(WOLFSBANE, (Object)new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.WOLFSBANE.get()))))));
        context.m_255272_(SILVER_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)stoneTest, (BlockState)((DropExperienceBlock)ModBlocks.SILVER_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateTest, (BlockState)((DropExperienceBlock)ModBlocks.DEEPSLATE_SILVER_ORE.get()).m_49966_())), 7)));
        context.m_255272_(WEREWOLF_HEAVEN_TREES, (Object)new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)new WeightedPlacedFeature((Holder)placedFeatures.m_255043_(JACARANDA_TREE_PLACED), 0.4f), (Object)new WeightedPlacedFeature((Holder)placedFeatures.m_255043_(TreePlacements.f_195385_), 0.1f), (Object)new WeightedPlacedFeature((Holder)placedFeatures.m_255043_(MAGIC_TREE_BIG_PLACED), 0.1f)), (Holder)placedFeatures.m_255043_(MAGIC_TREE_PLACED))));
    }

    public static void createPlacedFeatures(BootstapContext<PlacedFeature> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256911_);
        context.m_255272_(WOLFSBANE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(WOLFSBANE), List.of(RarityFilter.m_191900_((int)20), PlacementUtils.f_195352_, InSquarePlacement.m_191715_())));
        context.m_255272_(WEREWOLF_HAVEN_TREES_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(WEREWOLF_HEAVEN_TREES), VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)6, (float)0.2f, (int)2))));
        context.m_255272_(SILVER_ORE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(SILVER_ORE), WerewolvesBiomeFeatures.commonOrePlacement(WerewolvesConfig.COMMON.silverOreWeight, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-20), (VerticalAnchor)VerticalAnchor.m_158922_((int)50)))));
        context.m_255272_(MAGIC_TREE_BIG_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(MAGIC_TREE_BIG), List.of(PlacementUtils.m_206493_((Block)((Block)ModBlocks.MAGIC_SAPLING.get())))));
        context.m_255272_(MAGIC_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(MAGIC_TREE), List.of(PlacementUtils.m_206493_((Block)((Block)ModBlocks.MAGIC_SAPLING.get())))));
        context.m_255272_(JACARANDA_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(JACARANDA_TREE), List.of(PlacementUtils.m_206493_((Block)((Block)ModBlocks.JACARANDA_SAPLING.get())))));
    }

    public static void createBiomeModifier(BootstapContext<BiomeModifier> context) {
        HolderGetter biomeLookup = context.m_255420_(Registries.f_256952_);
        HolderGetter placedFeatureLookup = context.m_255420_(Registries.f_256988_);
        context.m_255272_(WEREWOLF_SPAWN, (Object)new ExtendedAddSpawnsBiomeModifier((HolderSet)biomeLookup.m_254956_(ModTags.Biomes.HasSpawn.WEREWOLF), (HolderSet)biomeLookup.m_254956_(ModTags.Biomes.NoSpawn.WEREWOLF), (List)Lists.newArrayList((Object[])new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData[]{new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.WEREWOLF_BEAST.get(), 80, 1, 2, MobCategory.MONSTER), new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.WEREWOLF_SURVIVALIST.get(), 80, 1, 2, MobCategory.MONSTER)})));
        context.m_255272_(HUMAN_WEREWOLF_SPAWN, (Object)ExtendedAddSpawnsBiomeModifier.singleSpawn((HolderSet)biomeLookup.m_254956_(ModTags.Biomes.HasSpawn.HUMAN_WEREWOLF), (HolderSet)biomeLookup.m_254956_(ModTags.Biomes.NoSpawn.HUMAN_WEREWOLF), (ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData)new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.HUMAN_WEREWOLF.get(), 5, 1, 1, MobCategory.MONSTER)));
        context.m_255272_(SILVER_ORE_GEN, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeLookup.m_254956_(ModTags.Biomes.HasGen.SILVER_ORE), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatureLookup.m_255043_(SILVER_ORE_PLACED)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.m_255272_(WOLFSBANE_GEN, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeLookup.m_254956_(ModTags.Biomes.HasGen.WOLFSBANE), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatureLookup.m_255043_(WOLFSBANE_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }
}

