/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui;

import de.teamlapen.lib.lib.client.gui.components.HoverList;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.network.ServerboundWerewolfAppearancePacket;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class WerewolfPlayerAppearanceScreen
extends AppearanceScreen<Player> {
    private static final Component NAME = Component.m_237115_((String)"gui.vampirism.appearance");
    private final WerewolfPlayer werewolf;
    private WerewolfForm activeForm;
    private int skinType;
    private int eyeType;
    private boolean glowingEyes;
    private boolean renderForm;
    private Button human;
    private Button beast;
    private Button survival;
    private HoverList<?> eyeList;
    private HoverList<?> skinList;
    private ExtendedButton eyeButton;
    private ExtendedButton skinButton;
    private Checkbox glowingEyesButton;

    public WerewolfPlayerAppearanceScreen(@Nullable Screen backScreen) {
        super(NAME, (LivingEntity)Minecraft.m_91087_().f_91074_, backScreen);
        this.werewolf = WerewolfPlayer.get((Player)Minecraft.m_91087_().f_91074_);
    }

    public void m_7861_() {
        this.updateServer();
        super.m_7861_();
    }

    public void m_6574_(@Nonnull Minecraft minecraft, int width, int height) {
        this.updateServer();
        WerewolfForm form = this.activeForm;
        super.m_6574_(minecraft, width, height);
        this.switchToForm(form);
    }

    private void updateServer() {
        WerewolvesMod.dispatcher.sendToServer((IMessage.IServerBoundMessage)new ServerboundWerewolfAppearancePacket(((Player)this.entity).m_19879_(), "", this.activeForm, this.eyeType, this.skinType, this.glowingEyes ? 1 : 0));
    }

    protected void m_7856_() {
        super.m_7856_();
        Tooltip notUnlocked = Tooltip.m_257550_((Component)Component.m_237115_((String)"text.werewolves.not_unlocked"));
        this.human = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 5, this.guiTop + 20, 67, 20, WerewolfForm.HUMAN.getTextComponent(), button1 -> this.switchToForm(WerewolfForm.HUMAN)));
        this.beast = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 71, this.guiTop + 20, 40, 20, WerewolfForm.BEAST.getTextComponent(), button1 -> this.switchToForm(WerewolfForm.BEAST)));
        this.survival = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 111, this.guiTop + 20, 55, 20, WerewolfForm.SURVIVALIST.getTextComponent(), button1 -> this.switchToForm(WerewolfForm.SURVIVALIST)));
        this.switchToForm(WerewolfForm.HUMAN);
        if (!this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.SURVIVAL_FORM.get())) {
            this.survival.m_257544_(notUnlocked);
        }
        if (!this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.BEAST_FORM.get())) {
            this.beast.m_257544_(notUnlocked);
        }
    }

    private void sync() {
        boolean beastUnlocked = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.BEAST_FORM.get());
        boolean survivalUnlocked = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.SURVIVAL_FORM.get());
        if (this.activeForm == WerewolfForm.BEAST) {
            this.beast.f_93623_ = false;
            this.human.f_93623_ = true;
            this.survival.f_93623_ = survivalUnlocked;
            this.glowingEyesButton.f_93623_ = true;
            this.glowingEyesButton.f_93624_ = true;
            this.eyeButton.f_93624_ = true;
        } else if (this.activeForm == WerewolfForm.SURVIVALIST) {
            this.beast.f_93623_ = beastUnlocked;
            this.human.f_93623_ = true;
            this.survival.f_93623_ = false;
            this.glowingEyesButton.f_93623_ = true;
            this.glowingEyesButton.f_93624_ = true;
            this.eyeButton.f_93624_ = true;
        } else {
            this.beast.f_93623_ = beastUnlocked;
            this.human.f_93623_ = false;
            this.survival.f_93623_ = survivalUnlocked;
            this.glowingEyesButton.f_93623_ = false;
            this.glowingEyesButton.f_93624_ = false;
            this.eyeButton.f_93624_ = false;
        }
    }

    private void switchToForm(final WerewolfForm form) {
        if (this.eyeButton != null) {
            this.m_169411_((GuiEventListener)this.eyeButton);
            this.m_169411_((GuiEventListener)this.skinButton);
            this.m_169411_((GuiEventListener)this.eyeList);
            this.m_169411_((GuiEventListener)this.skinList);
            this.m_169411_((GuiEventListener)this.glowingEyesButton);
        }
        if (this.activeForm != null) {
            this.updateServer();
        }
        this.activeForm = form;
        this.skinType = this.werewolf.getSkinType(form);
        this.eyeType = this.werewolf.getEyeType(form);
        this.glowingEyes = this.werewolf.hasGlowingEyes(form);
        this.glowingEyesButton = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.guiLeft + 20, this.guiTop + 90, 99, 20, (Component)Component.m_237115_((String)"gui.vampirism.appearance.glowing_eye"), this.glowingEyes){

            public void m_5691_() {
                super.m_5691_();
                WerewolfPlayerAppearanceScreen.this.glowingEyes = this.m_93840_();
                WerewolfPlayerAppearanceScreen.this.werewolf.setGlowingEyes(form, WerewolfPlayerAppearanceScreen.this.glowingEyes);
            }
        });
        this.eyeList = (HoverList)this.m_142416_((GuiEventListener)HoverList.builder((int)(this.guiLeft + 20), (int)(this.guiTop + 30 + 19 + 20), (int)99, (int)100).componentsWithClickAndHover(IntStream.range(0, 9).mapToObj(type -> Component.m_237115_((String)"text.werewolves.appearance.eye").m_130946_(" " + type)).toList(), this::eye, this::hoverEye).build());
        this.skinList = (HoverList)this.m_142416_((GuiEventListener)HoverList.builder((int)(this.guiLeft + 20), (int)(this.guiTop + 50 + 19 + 20), (int)99, (int)80).componentsWithClickAndHover(IntStream.range(0, form.getSkinTypes()).mapToObj(type -> Component.m_237115_((String)"text.werewolves.appearance.skin").m_130946_(" " + type)).toList(), this::skin, this::hoverSkin).build());
        this.eyeButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.eyeList.getLeft(), this.eyeList.getTop() - 20, this.eyeList.getWidth(), 20, (Component)Component.m_237119_(), b -> this.setEyeListVisibility(!this.eyeList.isVisible)));
        this.skinButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.skinList.getLeft(), this.skinList.getTop() - 20, this.skinList.getWidth(), 20, (Component)Component.m_237119_(), b -> this.setSkinListVisibility(!this.skinList.isVisible)));
        this.setEyeListVisibility(false);
        this.setSkinListVisibility(false);
        this.sync();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        List copyOf = List.copyOf(this.m_6702_());
        for (int i = copyOf.size() - 1; i >= 0; --i) {
            GuiEventListener listener = (GuiEventListener)copyOf.get(i);
            if (!listener.m_6375_(pMouseX, pMouseY, pButton)) continue;
            this.m_7522_(listener);
            if (pButton == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    public Optional<GuiEventListener> m_94729_(double pMouseX, double pMouseY) {
        List children = this.m_6702_();
        for (int i = children.size() - 1; i >= 0; --i) {
            GuiEventListener guieventlistener = (GuiEventListener)children.get(i);
            if (!guieventlistener.m_5953_(pMouseX, pMouseY)) continue;
            return Optional.of(guieventlistener);
        }
        return Optional.empty();
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderForm = true;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.eyeList.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.skinList.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderForm = false;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.eyeList.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY) && !this.skinList.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return true;
    }

    public boolean isRenderForm() {
        return this.renderForm;
    }

    public WerewolfForm getActiveForm() {
        return this.activeForm;
    }

    private void setEyeListVisibility(boolean show) {
        this.eyeButton.m_93666_((Component)Component.m_237115_((String)"text.werewolves.appearance.eye").m_130946_(" " + (this.eyeType + 1)));
        this.eyeList.isVisible = show;
        this.skinButton.f_93624_ = !show;
        boolean bl = this.glowingEyesButton.f_93624_ = !show;
        if (show) {
            this.skinList.isVisible = false;
        }
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.m_93666_((Component)Component.m_237115_((String)"text.werewolves.appearance.skin").m_130946_(" " + (this.skinType + 1)));
        this.skinList.isVisible = show;
        boolean bl = this.glowingEyesButton.f_93624_ = !show;
        if (show) {
            this.eyeList.isVisible = false;
        }
    }

    private void eye(int eyeType) {
        this.eyeType = eyeType;
        this.werewolf.setEyeType(this.activeForm, eyeType);
        this.setEyeListVisibility(false);
    }

    private void skin(int skinType) {
        this.skinType = skinType;
        this.werewolf.setSkinType(this.activeForm, skinType);
        this.setSkinListVisibility(false);
    }

    private void hoverEye(int eyeType, boolean hovered) {
        if (hovered) {
            this.werewolf.setEyeType(this.activeForm, eyeType);
        } else if (this.werewolf.getEyeType() == eyeType) {
            this.werewolf.setEyeType(this.activeForm, this.eyeType);
        }
    }

    private void hoverSkin(int skintype, boolean hovered) {
        if (hovered) {
            this.werewolf.setSkinType(this.activeForm, skintype);
        } else if (this.werewolf.getSkinType() == skintype) {
            this.werewolf.setSkinType(this.activeForm, this.skinType);
        }
    }
}

