/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model;

import com.google.common.collect.ImmutableList;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class WerewolfEarsModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public static final String HEAD = "head";
    public static final String CLAWS_LEFT = "clawsLeft";
    public static final String CLAWS_RIGHT = "clawsRight";
    public static final String EAR_RIGHT = "earRight";
    public static final String EAR_LEFT = "earLeft";
    public final ModelPart clawsLeft;
    public final ModelPart clawsRight;

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171597_(HEAD);
        PartDefinition earRight = head.m_171599_(EAR_RIGHT, CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-4.9f, -8.0f, -2.5f, 1.0f, 6.0f, 3.0f), PartPose.m_171430_((float)-0.4886922f, (float)-0.2617994f, (float)0.0f));
        PartDefinition earLeft = head.m_171599_(EAR_LEFT, CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(3.9f, -8.0f, -2.5f, 1.0f, 6.0f, 3.0f), PartPose.m_171430_((float)-0.4886922f, (float)0.2617994f, (float)0.0f));
        return mesh;
    }

    public static LayerDefinition createDefaultLayer() {
        MeshDefinition mesh = WerewolfEarsModel.createMesh();
        PartDefinition root = mesh.m_171576_();
        PartDefinition clawsRight = root.m_171597_("right_arm").m_171599_(CLAWS_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, 10.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.f_171404_);
        PartDefinition clawsLeft = root.m_171597_("left_arm").m_171599_(CLAWS_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-1.0f, 10.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public static LayerDefinition createSlimLayer() {
        MeshDefinition mesh = WerewolfEarsModel.createMesh();
        PartDefinition root = mesh.m_171576_();
        PartDefinition clawsRight = root.m_171597_("right_arm").m_171599_(CLAWS_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, 10.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.f_171404_);
        PartDefinition clawsLeft = root.m_171597_("left_arm").m_171599_(CLAWS_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-1.0f, 10.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public WerewolfEarsModel(ModelPart part) {
        super(part);
        this.f_102808_.f_233556_ = true;
        this.f_102811_.f_233556_ = true;
        this.f_102812_.f_233556_ = true;
        this.clawsRight = this.f_102811_.m_171324_(CLAWS_RIGHT);
        this.clawsLeft = this.f_102812_.m_171324_(CLAWS_LEFT);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102811_, (Object)this.f_102812_);
    }

    @Nonnull
    public static List<ResourceLocation> getHumanTextures() {
        List<ResourceLocation> locs = Minecraft.m_91087_().m_91098_().m_214159_("textures/entity/werewolf/human", s -> s.m_135815_().endsWith(".png")).keySet().stream().filter(r -> "werewolves".equals(r.m_135827_())).collect(Collectors.toList());
        if (locs.size() < WerewolfForm.HUMAN.getSkinTypes()) {
            for (int i = 0; i < WerewolfForm.HUMAN.getSkinTypes(); ++i) {
                ResourceLocation s2 = new ResourceLocation("werewolves", "textures/entity/werewolf/human/werewolf_ear_claws_" + i + ".png");
                if (locs.contains(s2)) continue;
                locs.add(s2);
            }
        }
        return locs;
    }
}

