/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WerewolfSurvivalistModel<T extends LivingEntity>
extends WerewolfBaseModel<T> {
    public static final String BODY = "body";
    public static final String HIP = "hip";
    public static final String NECK = "neck";
    public static final String ARM_LEFT = "armLeft";
    public static final String ARM_RIGHT = "armRight";
    public static final String BODY_FLUFF = "bodyFluff";
    public static final String LEG_LEFT = "legLeft";
    public static final String LEG_RIGHT = "legRight";
    public static final String TAIL = "tail";
    public static final String LEG_LEFT_2 = "legLeft2";
    public static final String FOOT_LEFT = "footLeft";
    public static final String LEG_RIGHT_2 = "legRight2";
    public static final String FOOT_RIGHT = "footRight";
    public static final String TAIL_2 = "tail2";
    public static final String TAIL_3 = "tail3";
    public static final String JOINT = "joint";
    public static final String NECK_FLUFF = "neckFluff";
    public static final String NECK_FLUFF_LEFT = "neckFluffLeft";
    public static final String NECK_FLUFF_RIGHT = "neckFluffRight";
    public static final String NECK_FLUFF_BOTTOM = "neckFluffBottom";
    public static final String HEAD = "head";
    public static final String EAR_LEFT = "earLeft";
    public static final String EAR_RIGHT = "earRight";
    public static final String SNOUT = "snout";
    public static final String JAW = "jaw";
    public static final String HEAD_FLUFF = "headFluff";
    public static final String HEAD_SIDEBURNS_LEFT = "headSideburnsLeft";
    public static final String HEAD_SIDEBURNS_RIGHT = "headSideburnsRight";
    public static final String NOSE = "nose";
    public static final String SNOUT_TEETH = "snoutTeeth";
    public static final String JAW_TEETH = "jawTeeth";
    public static final String JAW_FLUFF = "jawFluff";
    public static final String ARM_LEFT_2 = "armLeft2";
    public static final String FOOT_LEFT_1 = "footLeft_1";
    public static final String ARM_RIGHT_2 = "armRight2";
    public static final String FOOT_LEFT_2 = "footLeft_2";
    public final ModelPart head;
    public final ModelPart hip;
    public final ModelPart body;
    public final ModelPart armLeft;
    public final ModelPart armRight;
    public final ModelPart legRight;
    public final ModelPart legLeft;
    public final ModelPart tail;
    public final ModelPart jaw;
    public final ModelPart jawTeeth;
    public final ModelPart neck;
    public final ModelPart joint;
    private final List<ModelPart> parts;

    public WerewolfSurvivalistModel(ModelPart part) {
        super(part);
        this.body = part.m_171324_(BODY);
        this.hip = this.body.m_171324_(HIP);
        this.tail = this.hip.m_171324_(TAIL);
        this.legRight = this.hip.m_171324_(LEG_RIGHT);
        this.legLeft = this.hip.m_171324_(LEG_LEFT);
        this.armLeft = this.body.m_171324_(ARM_LEFT);
        this.armRight = this.body.m_171324_(ARM_RIGHT);
        this.neck = this.body.m_171324_(NECK);
        this.joint = this.neck.m_171324_(JOINT);
        this.head = this.joint.m_171324_(HEAD);
        this.jaw = this.head.m_171324_(JAW);
        this.jawTeeth = this.jaw.m_171324_(JAW_TEETH);
        this.parts = part.m_171331_().filter(s -> !s.m_171326_()).toList();
    }

    @Nonnull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = WerewolfBaseModel.createMesh(CubeDeformation.f_171458_);
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_(BODY, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-4.5f, 0.0f, -4.0f, 9.0f, 8.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)9.5f, (float)-2.5f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_(NECK, CubeListBuilder.m_171558_().m_171514_(0, 45).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 7.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)1.0f, (float)-0.31415927f, (float)0.0f, (float)0.0f));
        PartDefinition joint = neck.m_171599_(JOINT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)-6.5f, (float)-1.0f, (float)-1.2217305f, (float)0.0f, (float)0.0f));
        PartDefinition head = joint.m_171599_(HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition snout = head.m_171599_(SNOUT, CubeListBuilder.m_171558_().m_171514_(34, 0).m_171481_(-2.0f, -2.0f, -4.0f, 4.0f, 2.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-5.0f));
        PartDefinition jaw = head.m_171599_(JAW, CubeListBuilder.m_171558_().m_171514_(50, 0).m_171481_(-1.5f, 0.0f, -3.5f, 3.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)-5.0f, (float)0.4553564f, (float)0.0f, (float)0.0f));
        PartDefinition hip = body.m_171599_(HIP, CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-3.5f, 0.0f, -3.0f, 7.0f, 9.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-0.9f));
        PartDefinition armLeft = body.m_171599_(ARM_LEFT, CubeListBuilder.m_171558_().m_171514_(36, 25).m_171481_(0.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)1.5f, (float)3.0f, (float)-1.5f, (float)1.2217305f, (float)0.0f, (float)0.0f));
        PartDefinition armLeft2 = armLeft.m_171599_(ARM_LEFT_2, CubeListBuilder.m_171558_().m_171514_(48, 15).m_171481_(-1.5f, 0.0f, -2.0f, 3.0f, 8.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)2.0f, (float)5.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition footLeft_1 = armLeft2.m_171599_(FOOT_LEFT_1, CubeListBuilder.m_171558_().m_171514_(24, 54).m_171481_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f).m_171480_(), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)-0.5f));
        PartDefinition snoutTeeth = snout.m_171599_(SNOUT_TEETH, CubeListBuilder.m_171558_().m_171514_(34, 6).m_171481_(-2.0f, 0.0f, -4.0f, 4.0f, 2.0f, 4.0f), PartPose.f_171404_);
        PartDefinition bodyFluff = body.m_171599_(BODY_FLUFF, CubeListBuilder.m_171558_().m_171514_(82, 14).m_171481_(-4.5f, 8.0f, -4.0f, 9.0f, 3.0f, 8.0f), PartPose.f_171404_);
        PartDefinition legRight = hip.m_171599_(LEG_RIGHT, CubeListBuilder.m_171558_().m_171514_(24, 39).m_171481_(-4.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f), PartPose.m_171423_((float)-0.5f, (float)8.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition legLeft = hip.m_171599_(LEG_LEFT, CubeListBuilder.m_171558_().m_171514_(24, 39).m_171481_(0.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f), PartPose.m_171423_((float)0.5f, (float)8.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition legLeft2 = legLeft.m_171599_(LEG_LEFT_2, CubeListBuilder.m_171558_().m_171514_(44, 44).m_171481_(0.5f, 2.0f, 1.0f, 3.0f, 10.0f, 4.0f).m_171480_(), PartPose.f_171404_);
        PartDefinition tail = hip.m_171599_(TAIL, CubeListBuilder.m_171558_().m_171514_(62, 30).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)2.0f, (float)-0.22759093f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.m_171599_(TAIL_2, CubeListBuilder.m_171558_().m_171514_(62, 37).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_(TAIL_3, CubeListBuilder.m_171558_().m_171514_(62, 49).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)7.8f, (float)0.0f, (float)0.13665928f, (float)0.0f, (float)0.0f));
        PartDefinition headSideburnsLeft = head.m_171599_(HEAD_SIDEBURNS_LEFT, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171481_(1.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f), PartPose.m_171430_((float)0.0f, (float)-0.5235988f, (float)0.0f));
        PartDefinition neckFluffRight = neck.m_171599_(HEAD_SIDEBURNS_RIGHT, CubeListBuilder.m_171558_().m_171514_(82, 25).m_171481_(-3.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f), PartPose.m_171430_((float)0.34906584f, (float)-1.5707964f, (float)0.0f));
        PartDefinition footLeft = legLeft2.m_171599_(FOOT_LEFT, CubeListBuilder.m_171558_().m_171514_(24, 54).m_171481_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f).m_171480_(), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)2.5f));
        PartDefinition headFluff = head.m_171599_(HEAD_FLUFF, CubeListBuilder.m_171558_().m_171514_(96, 0).m_171481_(-3.5f, 3.5f, -5.0f, 7.0f, 2.0f, 6.0f), PartPose.f_171404_);
        PartDefinition legRight2 = legRight.m_171599_(LEG_RIGHT_2, CubeListBuilder.m_171558_().m_171514_(44, 44).m_171481_(-3.5f, 2.0f, 1.0f, 3.0f, 10.0f, 4.0f), PartPose.f_171404_);
        PartDefinition earRight = head.m_171599_(EAR_RIGHT, CubeListBuilder.m_171558_().m_171514_(26, 0).m_171481_(-3.5f, -6.5f, -1.0f, 2.0f, 3.0f, 1.0f), PartPose.f_171404_);
        PartDefinition headSideburnsRight = head.m_171599_(HEAD_SIDEBURNS_RIGHT, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171481_(-4.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f).m_171480_(), PartPose.m_171430_((float)0.0f, (float)0.5235988f, (float)0.0f));
        PartDefinition jawFluff = jaw.m_171599_(JAW_FLUFF, CubeListBuilder.m_171558_().m_171514_(96, 8).m_171481_(-1.5f, 2.0f, -3.5f, 3.0f, 2.0f, 4.0f), PartPose.f_171404_);
        PartDefinition footRight = legRight2.m_171599_(FOOT_RIGHT, CubeListBuilder.m_171558_().m_171514_(24, 54).m_171481_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)2.5f));
        PartDefinition neckFluff = neck.m_171599_(NECK_FLUFF, CubeListBuilder.m_171558_().m_171514_(64, 19).m_171481_(-3.5f, -5.0f, 2.5f, 7.0f, 8.0f, 2.0f), PartPose.m_171430_((float)0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition armRight = body.m_171599_(ARM_RIGHT, CubeListBuilder.m_171558_().m_171514_(36, 25).m_171481_(-4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.m_171423_((float)-1.5f, (float)3.0f, (float)-1.5f, (float)-1.2217305f, (float)0.0f, (float)0.0f));
        PartDefinition armRight2 = armRight.m_171599_(ARM_RIGHT_2, CubeListBuilder.m_171558_().m_171514_(48, 15).m_171481_(-1.5f, 0.0f, -2.0f, 3.0f, 8.0f, 4.0f), PartPose.m_171423_((float)-2.0f, (float)5.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition neckFluffLeft = neck.m_171599_(NECK_FLUFF_LEFT, CubeListBuilder.m_171558_().m_171514_(82, 25).m_171481_(-2.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f), PartPose.m_171430_((float)0.34906584f, (float)1.5707964f, (float)0.0f));
        PartDefinition neckFluffBottom = neck.m_171599_(NECK_FLUFF_BOTTOM, CubeListBuilder.m_171558_().m_171514_(80, 0).m_171481_(-3.0f, -0.6f, 4.5f, 6.0f, 6.0f, 2.0f), PartPose.m_171430_((float)1.0471976f, (float)((float)Math.PI), (float)0.0f));
        PartDefinition earLeft = head.m_171599_(EAR_LEFT, CubeListBuilder.m_171558_().m_171514_(26, 0).m_171481_(1.5f, -6.5f, -1.0f, 2.0f, 3.0f, 1.0f).m_171480_(), PartPose.f_171404_);
        PartDefinition nose = snout.m_171599_(NOSE, CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-1.5f, -3.5f, -3.7f, 3.0f, 2.0f, 5.0f), PartPose.m_171430_((float)0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition jawTeeth = jaw.m_171599_(JAW_TEETH, CubeListBuilder.m_171558_().m_171514_(50, 6).m_171481_(-1.5f, -1.0f, -3.5f, 3.0f, 1.0f, 4.0f), PartPose.f_171404_);
        PartDefinition footLeft_2 = armRight2.m_171599_(FOOT_LEFT_2, CubeListBuilder.m_171558_().m_171514_(24, 54).m_171481_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)-0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    @Override
    @Nullable
    public ModelPart getModelRenderer() {
        return this.body;
    }

    @Override
    @Nullable
    public ModelPart getHeadModel() {
        return this.head;
    }

    @Override
    @Nullable
    public ModelPart getLeftArmModel() {
        return this.armLeft;
    }

    @Override
    @Nullable
    public ModelPart getRightArmModel() {
        return this.armRight;
    }

    @Override
    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }

    public void m_7695_(@Nonnull PoseStack matrixStackIn, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.body.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public void m_6973_(@Nonnull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_102817_ = entityIn.m_6047_();
        boolean flag1 = entityIn.m_6067_();
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.m_7884_(entityIn, ageInTicks);
        this.legRight.f_104203_ = -1.5707964f;
        this.legLeft.f_104203_ = -1.5707964f;
        this.armRight.f_104203_ = -1.2217305f;
        this.armLeft.f_104203_ = -1.2217305f;
        this.legRight.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f * 0.8f + 4.712389f)) * 0.8f * limbSwingAmount;
        this.legLeft.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f * 0.8f + 1.5707964f)) * 0.8f * limbSwingAmount;
        this.armRight.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f * 0.8f)) * 0.8f * limbSwingAmount;
        this.armLeft.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f * 0.8f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        if (this.f_102817_) {
            this.armLeft.f_104203_ += -0.4f;
            this.armRight.f_104203_ += -0.4f;
            this.legLeft.f_104203_ += 0.1f;
            this.legRight.f_104203_ += 0.1f;
            this.body.f_104201_ = 10.5f;
            this.neck.f_104203_ = -0.11415926f;
            this.hip.f_104203_ = 0.05f;
            this.hip.f_104201_ = 7.0f;
        } else {
            this.body.f_104201_ = 9.5f;
            this.neck.f_104203_ = -0.31415927f;
            this.hip.f_104203_ = 0.0f;
            this.hip.f_104201_ = 6.0f;
        }
        this.tail.f_104203_ = -0.22759093f;
        this.tail.f_104203_ -= 0.035f;
        this.tail.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.07f;
        this.tail.f_104204_ = -0.035f;
        this.tail.f_104204_ += Mth.m_14031_((float)(ageInTicks * 0.14f)) * 0.07f;
        this.tail.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f * 0.7f)) * 0.3f * Mth.m_14154_((float)limbSwingAmount) + 0.3f;
        this.tail.f_104204_ += Mth.m_14031_((float)(limbSwing * 0.6662f * 0.7f)) * 0.1f * limbSwingAmount;
    }

    @Override
    @NotNull
    protected ModelPart m_102851_(@NotNull HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.armRight : this.armLeft;
    }

    public void translateToMouth(@NotNull HumanoidArm arm, @NotNull PoseStack stack) {
        this.body.m_104299_(stack);
        this.neck.m_104299_(stack);
        this.joint.m_104299_(stack);
        this.head.m_104299_(stack);
        this.jaw.m_104299_(stack);
    }

    protected void m_7884_(T entity, float ageInTicks) {
        if (this.f_102608_ > 0.0f) {
            float f = this.f_102608_;
            f = 1.0f - f;
            this.head.f_104203_ += f;
        }
    }

    @Nonnull
    public static List<ResourceLocation> getSurvivalTextures() {
        List<ResourceLocation> locs = WerewolfSurvivalistModel.getTextures("textures/entity/werewolf/survivalist");
        if (locs.size() < WerewolfForm.SURVIVALIST.getSkinTypes()) {
            for (int i = locs.size(); i < WerewolfForm.SURVIVALIST.getSkinTypes(); ++i) {
                ResourceLocation s = new ResourceLocation("werewolves", "textures/entity/werewolf/survivalist/survivalist_" + i + ".png");
                locs.add(s);
            }
        }
        return locs;
    }

    @NotNull
    public ModelPart m_233438_(RandomSource pRandom) {
        return this.parts.get(pRandom.m_188503_(this.parts.size()));
    }
}

