/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.entity.player.skills.ActionSkill;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.SurvivalWerewolfFormAction;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.entities.player.werewolf.skill.DiggerSkill;
import de.teamlapen.werewolves.entities.player.werewolf.skill.FormActionSkill;
import de.teamlapen.werewolves.entities.player.werewolf.skill.SimpleWerewolfSkill;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.SkillUtils;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModSkills {
    public static final DeferredRegister<ISkill<?>> SKILLS = DeferredRegister.create((ResourceKey)VampirismRegistries.SKILLS_ID, (String)"werewolves");
    public static final RegistryObject<ISkill<IWerewolfPlayer>> HUMAN_FORM = SKILLS.register("human_form", () -> new FormActionSkill((Supplier<WerewolfFormAction>)ModActions.HUMAN_FORM, 2));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> NIGHT_VISION = SKILLS.register("night_vision", () -> new SimpleWerewolfSkill(true).setToggleActions(player -> {
        ((WerewolfPlayer)player).getSpecialAttributes().night_vision = true;
    }, player -> {
        ((WerewolfPlayer)player).getSpecialAttributes().night_vision = false;
    }));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> RAGE = SKILLS.register("rage", () -> new ActionSkill(ModActions.RAGE, 2, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> BEAST_FORM = SKILLS.register("beast_form", () -> new FormActionSkill((Supplier<WerewolfFormAction>)ModActions.BEAST_FORM, 3));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> SURVIVAL_FORM = SKILLS.register("survival_form", () -> new FormActionSkill((Supplier<WerewolfFormAction>)ModActions.SURVIVAL_FORM, 3));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> STUN_BITE = SKILLS.register("stun_bite", () -> {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> BEAST_FORM.get();
        supplierArray[1] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> BLEEDING_BITE = SKILLS.register("bleeding_bite", () -> {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> BEAST_FORM.get();
        supplierArray[1] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> DAMAGE = SKILLS.register("damage", () -> {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> BEAST_FORM.get();
        supplierArray[1] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> HEALTH_AFTER_KILL = SKILLS.register("health_after_kill", () -> new SimpleWerewolfSkill(1, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> HOWLING = SKILLS.register("howling", () -> new ActionSkill(ModActions.HOWLING, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> SENSE = SKILLS.register("sense", () -> new ActionSkill(ModActions.SENSE, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> SPEED = SKILLS.register("speed", () -> new SimpleWerewolfSkill.AttributeSkill("speed", true, SkillUtils.SPEED_SKILL, Attributes.f_22279_, AttributeModifier.Operation.ADDITION, player -> (Double)WerewolvesConfig.BALANCE.SKILLS.speed_amount.get()));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> JUMP = SKILLS.register("jump", () -> new SimpleWerewolfSkill(true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> LEAP = SKILLS.register("leap", () -> new ActionSkill(ModActions.LEAP, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> WOLF_PACK = SKILLS.register("wolf_pack", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> HOWLING.get();
        return new SimpleWerewolfSkill(1).defaultDescWithEnhancement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> MOVEMENT_TACTICS = SKILLS.register("movement_tactics", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill().defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> THROAT_SEEKER = SKILLS.register("throat_seeker", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> BEAST_FORM.get();
        return new SimpleWerewolfSkill().defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> CLIMBER = SKILLS.register("climber", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill().defaultDescWithFormRequirement(supplierArray).setToggleActions(SurvivalWerewolfFormAction::climberSkillEnabled, SurvivalWerewolfFormAction::climberSkillDisabled);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> WOLF_PAWN = SKILLS.register("wolf_pawn", () -> new SimpleWerewolfSkill(1, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> NOT_MEAT = SKILLS.register("not_meat", () -> new SimpleWerewolfSkill(3, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> WATER_LOVER = SKILLS.register("water_lover", () -> new SimpleWerewolfSkill(true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> FREE_WILL = SKILLS.register("free_will", () -> new SimpleWerewolfSkill(true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> WEAR_ARMOR = SKILLS.register("wear_armor", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> HUMAN_FORM.get();
        return new SimpleWerewolfSkill(3).defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> SILVER_BLOODED = SKILLS.register("silver_blooded", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> HUMAN_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> HIDE_NAME = SKILLS.register("hide_name", () -> new ActionSkill(ModActions.HIDE_NAME, 1, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> FEAR = SKILLS.register("fear", () -> new ActionSkill(ModActions.FEAR, 1, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> SIXTH_SENSE = SKILLS.register("sixth_sense", () -> new SimpleWerewolfSkill(1, true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> HEALTH_REG = SKILLS.register("health_reg", () -> new SimpleWerewolfSkill(true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> THICK_FUR = SKILLS.register("thick_fur", () -> {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> BEAST_FORM.get();
        supplierArray[1] = () -> SURVIVAL_FORM.get();
        supplierArray[2] = () -> HUMAN_FORM.get();
        return new SimpleWerewolfSkill().defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> DIGGER = SKILLS.register("digger", DiggerSkill::new);
    public static final RegistryObject<ISkill<IWerewolfPlayer>> ENHANCED_DIGGER = SKILLS.register("enhanced_digger", DiggerSkill::new);
    public static final RegistryObject<ISkill<IWerewolfPlayer>> MINION_STATS_INCREASE = SKILLS.register("werewolf_minion_stats_increase", () -> new SimpleWerewolfSkill.LordWerewolfSkill(true).setToggleActions(IWerewolfPlayer::updateMinionAttributes));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> MINION_COLLECT = SKILLS.register("werewolf_minion_collect", () -> new SimpleWerewolfSkill.LordWerewolfSkill(true));
    public static final RegistryObject<ISkill<IWerewolfPlayer>> BEAST_RAGE = SKILLS.register("beast_rage", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> BEAST_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> ARROW_AWARENESS = SKILLS.register("arrow_awareness", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final RegistryObject<ISkill<IWerewolfPlayer>> EFFICIENT_DIET = SKILLS.register("efficient_diet", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });

    static void register(IEventBus bus) {
        SKILLS.register(bus);
    }

    static {
        SKILLS.register(SkillType.LEVEL.createIdForFaction(REFERENCE.WEREWOLF_PLAYER_KEY).m_135815_(), () -> new SimpleWerewolfSkill(false));
        SKILLS.register(SkillType.LORD.createIdForFaction(REFERENCE.WEREWOLF_PLAYER_KEY).m_135815_(), () -> new SimpleWerewolfSkill.LordWerewolfSkill(false));
    }
}

