/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf;

import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class WerewolfInventory {
    private final WerewolfPlayer werewolf;
    private final Map<WerewolfForm, List<ItemStack>> inventories;
    private WerewolfForm form = WerewolfForm.NONE;

    public WerewolfInventory(WerewolfPlayer werewolf) {
        this.werewolf = werewolf;
        HashMap<WerewolfForm, List<ItemStack>> inventories = new HashMap<WerewolfForm, List<ItemStack>>();
        WerewolfForm.getAllForms().forEach(form -> inventories.put((WerewolfForm)form, (List<ItemStack>)NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_)));
        this.inventories = inventories;
    }

    public void swapArmorItems(WerewolfForm to) {
        boolean armor = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WEAR_ARMOR.get()) && to != WerewolfForm.NONE && to.isHumanLike();
        NonNullList previousArmor = this.werewolf.getRepresentingPlayer().m_150109_().f_35975_;
        this.inventories.put(this.form, new ArrayList(previousArmor));
        previousArmor.clear();
        List<ItemStack> itemStacks = this.inventories.get(to);
        if (armor && itemStacks.stream().allMatch(ItemStack::m_41619_)) {
            to = WerewolfForm.NONE;
            itemStacks = this.inventories.get(to);
        }
        for (int i = 0; i < 4; ++i) {
            previousArmor.set(i, itemStacks.get(i));
        }
        this.inventories.put(to, (List<ItemStack>)previousArmor);
        this.form = to;
    }

    public void dropEquipment() {
        Player player = this.werewolf.getRepresentingPlayer();
        for (List<ItemStack> list : this.inventories.values()) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = list.get(i);
                if (stack.m_41619_()) continue;
                player.m_7197_(stack, true, false);
                list.set(i, ItemStack.f_41583_);
            }
        }
    }

    public void dropFormEquipment(WerewolfForm form) {
        Player player = this.werewolf.getRepresentingPlayer();
        List<ItemStack> list = this.inventories.get(form);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = list.get(i);
            if (stack.m_41619_()) continue;
            if (!player.m_36356_(stack)) {
                player.m_36176_(stack, false);
            }
            list.set(i, ItemStack.f_41583_);
        }
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("lastForm", this.form.getName());
        CompoundTag tag = new CompoundTag();
        nbt.m_128365_("inventory", (Tag)tag);
        this.inventories.forEach((form, armor) -> {
            ListTag list = new ListTag();
            for (int i = 0; i < armor.size(); ++i) {
                ItemStack stack = (ItemStack)armor.get(i);
                if (stack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128344_("Slot", (byte)i);
                stack.m_41739_(itemTag);
                list.add((Object)itemTag);
            }
            tag.m_128365_(form.getName(), (Tag)list);
        });
        return nbt;
    }

    public void load(CompoundTag tag) {
        this.form = Objects.requireNonNullElse(WerewolfForm.getForm(tag.m_128461_("lastForm")), WerewolfForm.NONE);
        CompoundTag inventory = tag.m_128469_("inventory");
        inventory.m_128431_().stream().map(WerewolfForm::getForm).forEach(form -> {
            ListTag list = inventory.m_128437_(form.getName(), 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag itemTag = list.m_128728_(i);
                int slot = itemTag.m_128445_("Slot") & 0xFF;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                this.inventories.get(form).set(slot, stack);
            }
        });
    }
}

