/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.items;

import de.teamlapen.werewolves.blocks.WerewolvesBoatEntity;
import de.teamlapen.werewolves.blocks.WerewolvesChestBoatEntity;
import de.teamlapen.werewolves.items.IWerewolvesBoat;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WerewolvesBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final IWerewolvesBoat.BoatType type;
    private final boolean hasChest;

    public WerewolvesBoatItem(IWerewolvesBoat.BoatType type, boolean hasChest, @NotNull Item.Properties properties) {
        super(properties);
        this.type = type;
        this.hasChest = hasChest;
    }

    public IWerewolvesBoat.BoatType getType() {
        return this.type;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level p_77659_1_, @NotNull Player p_77659_2_, InteractionHand p_77659_3_) {
        ItemStack itemstack = p_77659_2_.m_21120_(p_77659_3_);
        BlockHitResult hitresult = WerewolvesBoatItem.m_41435_((Level)p_77659_1_, (Player)p_77659_2_, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 vec3 = p_77659_2_.m_20252_(1.0f);
        double d0 = 5.0;
        List list = p_77659_1_.m_6249_((Entity)p_77659_2_, p_77659_2_.m_20191_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = p_77659_2_.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec31)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            IWerewolvesBoat boat = this.getBoat(p_77659_1_, (HitResult)hitresult);
            Entity botEntity = (Entity)boat;
            boat.setType(this.type);
            botEntity.m_146922_(p_77659_2_.m_146908_());
            if (!p_77659_1_.m_45756_(botEntity, botEntity.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!p_77659_1_.f_46443_) {
                p_77659_1_.m_7967_(botEntity);
                p_77659_1_.m_220400_((Entity)p_77659_2_, GameEvent.f_157810_, hitresult.m_82450_());
                if (!p_77659_2_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            p_77659_2_.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)p_77659_1_.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    @NotNull
    private IWerewolvesBoat getBoat(Level level, @NotNull HitResult hitResult) {
        return this.hasChest ? new WerewolvesChestBoatEntity(level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_) : new WerewolvesBoatEntity(level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
    }
}

